/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.type;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.BulkDataWriter;
import dev.xkmc.fastprojectileapi.render.core.DanmakuRenderStates;
import dev.xkmc.fastprojectileapi.render.core.DisplayType;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import dev.xkmc.fastprojectileapi.render.type.RenderableDanmakuType;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public record RotatingProjectileType(ResourceLocation tex, DisplayType display, double rot) implements RenderableDanmakuType<RotatingProjectileType, Ins>
{
    @Override
    public void start(MultiBufferSource buffer, List<Ins> list) {
        BulkDataWriter vc = new BulkDataWriter(buffer.m_6299_(DanmakuRenderStates.danmaku(this.tex, this.display())), list.size());
        for (Ins e : list) {
            e.tex(vc);
        }
        vc.flush();
    }

    @Override
    public void create(Consumer<Ins> holder, ProjectileRenderer<?> r, SimplifiedProjectile e, PoseStack pose, float pTick) {
        Matrix4f sim4 = new Matrix4f((Matrix4fc)pose.m_85850_().m_252922_());
        sim4.set3x3(new Matrix4f().scale((float)Math.pow(sim4.determinant3x3(), 0.3333333333333333)));
        Quaternionf q4 = Axis.f_252403_.m_252977_(((float)e.f_19797_ + pTick) * 360.0f / (float)this.rot);
        sim4.rotate((Quaternionfc)q4);
        int col = DanmakuRenderStates.fading(this.display, -1, r, e);
        holder.accept(new Ins(sim4, col));
    }

    public record Ins(Matrix4f m4, int color) {
        public void tex(BulkDataWriter vc) {
            Ins.vertex(vc, this.m4, 1.0f, 1, 1, 0, this.color);
            Ins.vertex(vc, this.m4, 1.0f, 0, 1, 1, this.color);
            Ins.vertex(vc, this.m4, 0.0f, 0, 0, 1, this.color);
            Ins.vertex(vc, this.m4, 0.0f, 1, 0, 0, this.color);
        }

        private static void vertex(BulkDataWriter vc, Matrix4f m4, float x, int y, int u, int v, int color) {
            vc.addVertex(m4, x - 0.5f, (float)y - 0.5f, 0.0f, u, v, color);
        }
    }
}

